"use client"

import {Card, CardContent, CardDescription, CardHeader, CardTitle} from "@/components/ui/card";
import {Label} from "@/components/ui/label";
import {Input} from "@/components/ui/input";
import {Button} from "@/components/ui/button";
import Link from "next/link";
import {useState} from "react";
import { sendOTP } from "@/lib/api";
import { useRouter } from "next/navigation";

export default function ForgotPassword(){

    const [email, setEmail] = useState('');
    const [error, setError] = useState('');
    const router = useRouter();

    const handleForgotPassword = async (e) => {
        e.preventDefault();

        try{
            const res = await sendOTP({email});

            if(res.status === "success"){
                console.log(res);
                alert("Successfully! " + res.message);
                sessionStorage.setItem('email', email);
                router.push('/otp');
            }
        }
        catch(err){
            setError(err);
        }

    }

    return(
        <div className="flex min-h-screen flex-col items-center p-24">
            <Card className="w-[400px]">
                <CardHeader>
                    <CardTitle>Forgot Password</CardTitle>
                    <CardDescription>Please enter your account email</CardDescription>
                    {error && <p className="text-red-500">{error}</p>}
                </CardHeader>
                <CardContent>
                    <form onSubmit={handleForgotPassword}>
                        <div className="grid w-full items-center gap-4 mb-3">
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="email">Email Address</Label>
                                <Input name="email" id="email" type="email" value={email} onChange={(e) => setEmail(e.target.value)} placeholder="Email" />
                            </div>
                            <div className="flex justify-between w-full">
                                <Button type="submit">Submit</Button>
                                <Link href="/login"><Button variant="outline">Login</Button></Link>
                            </div>
                        </div>
                    </form>
                </CardContent>
            </Card>
        </div>
    )
}