"use client"

import {Card, CardContent, CardDescription, CardHeader, CardTitle} from "@/components/ui/card";
import {Label} from "@/components/ui/label";
import {Input} from "@/components/ui/input";
import {Button} from "@/components/ui/button";
import Link from "next/link";
import {useState} from "react";
import {resetPassword} from "@/lib/api";
import {useRouter} from "next/navigation";

export default function ResetPassword(){
    const [password, setPassword] = useState('');
    const [confirmPassword, setConfirmPassword] = useState('');
    const [error, setError] = useState('');
    const router = useRouter();

    const handleResetPassword = async (e) => {
        e.preventDefault();

        if(password !== confirmPassword){
            setError('Password and confirm password should be same');
            return;
        }

        try{
            const res = await resetPassword({password});
            if(res.status === "success"){
                console.log(res);
                alert("Successfully! " + res.message);
                // router.push('/login');
                window.location.href = '/login';
            }
        }
        catch(err){
            setError(err);
        }
    }

    return(
        <div className="flex min-h-screen flex-col items-center p-24">
            <Card className="w-[400px]">
                <CardHeader>
                    <CardTitle>Reset Password</CardTitle>
                    <CardDescription>Please enter your new password </CardDescription>
                    {error && <p className="text-red-500">{error}</p>}
                </CardHeader>
                <CardContent>
                    <form onSubmit={handleResetPassword}>
                        <div className="grid w-full items-center gap-4 mb-3">
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="password">Enter New Password</Label>
                                <Input name="password" id="password" type="password" value={password} onChange={(e) => setPassword(e.target.value)} placeholder="Enter New Password" />
                            </div>
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="confirm password">Confirm Password</Label>
                                <Input name="cpassword" id="cpassword" type="password" value={confirmPassword} onChange={(e) => setConfirmPassword(e.target.value)} placeholder="Confirm Password" />
                            </div>
                            <div className="flex justify-between w-full">
                                <Button type="submit">Reset Password</Button>
                            </div>
                        </div>
                    </form>
                </CardContent>
            </Card>
        </div>
    )
}