"use client"

import { Button } from "@/components/ui/button"
import {
    Card,
    CardContent,
    CardDescription,
    CardFooter,
    CardHeader,
    CardTitle,
} from "@/components/ui/card"
import { Input } from "@/components/ui/input"
import { Label } from "@/components/ui/label"
import { useState } from "react";
import useAuth from "@/lib/useAuth";
import Link from "next/link";
import {toast} from "sonner";

export default function LoginPage(){

    const { login } = useAuth();
    const [formData, setFormData] = useState({email: '', password: ''});
    const [error, setError] = useState('');

    const handleSubmit = async (e) => {
        e.preventDefault();
        setError(''); // Clear any previous error message
        try {
            if (formData.email === ''){
                toast.error('Email field is required');
            } else if(formData.password === '') {
                toast.error('Password field is required');
                return;
            }else{
                await login(formData.email, formData.password);
            }
        } catch (err) {
            console.error(err);
            toast.error('Login failed! Please check your credentials and try again.');
        }
    }

    return(
        <div className="flex min-h-screen flex-col items-center p-24">
            <Card className="w-[400px]">
                <CardHeader>
                    <CardTitle>User Login</CardTitle>
                    <CardDescription>Please login to your account</CardDescription>
                    {error && <p className="text-red-500">{error}</p>}
                </CardHeader>
                <CardContent>
                    <form onSubmit={handleSubmit}>
                        <div className="grid w-full items-center gap-4 mb-3">
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="email">Email Address</Label>
                                <Input name="email" id="email" type="email" value={formData.email} onChange={(e) => setFormData({...formData, email: e.target.value})} placeholder="Email" />
                            </div>
                            <div className="flex flex-col space-y-1.0">
                                <Label className="mb-2 px-3" htmlFor="password">Password</Label>
                                <Input name="password" id="password" type="password" value={formData.password} onChange={(e) => setFormData({...formData, password: e.target.value})} placeholder="Password" />
                            </div>
                        </div>
                        <div className="flex justify-between w-full">
                            <Button type="submit">Login</Button>
                            <Link className="underline pt-3 text-sm" href="/forgot-password">Forgot Password?</Link>
                        </div>
                    </form>
                </CardContent>
                <CardFooter className="flex justify-between">
                    <p className="text-sm">Do not have an account? <Link className="underline" href="/register">Register</Link></p>
                </CardFooter>
            </Card>
        </div>
    )
}