import Link from "next/link";
import {Button} from "@/components/ui/button";
import {CircleUserRound, Home} from "lucide-react";
import {cookies} from "next/headers";
import {jwtDecode} from "jwt-decode";

export default function notFound(){
    const token = cookies().get('authToken')?.value;
    let user = jwtDecode(token);

    return(
        <div className="flex flex-col justify-center items-center p-24">
            <h2 className="text-2xl mb-3">404 - Page Not Found</h2>
            <p className="text-md mb-3">The page you are looking for does not exist.</p>
            {user['role'] === 'admin' ? (
                <Link href="/admin"><Button variant="outline"><Home className="h-[1.2rem] w-[2rem] rotate-0 scale-100 transition-all dark:-rotate-90 dark:scale-0" />Goto Home</Button></Link>
                ) : (
                    <Link href="/user"><Button variant="outline"><Home className="h-[1.2rem] w-[2rem] rotate-0 scale-100 transition-all dark:-rotate-90 dark:scale-0" />Goto Home</Button></Link>
            )}
        </div>
    )
}