import { ThemeProvider } from "@/components/theme-provider";
import Navbar from "../components/user/navbar";
import UserNavbar from "@/app/components/user/userNavbar";
import UserHeader from "@/app/components/user/userHeader";

export default function UserLayout( {children} ) {
    return(
        <div>
            <ThemeProvider
                attribute="class"
                defaultTheme="system"
                enableSystem
                disableTransitionOnChange>

                <div className="grid min-h-screen w-full md:grid-cols-[220px_1fr] lg:grid-cols-[240px_1fr]">
                    <UserNavbar />
                    <div className="flex flex-col">
                        <UserHeader />
                        <main className="flex flex-1 flex-col gap-4 p-4 lg:gap-6 lg:p-6">
                            {children}
                        </main>

                    </div>
                </div>
            </ThemeProvider>
        </div>
    )
}